/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenFissure
implements IWorldGenerator {
    private final IBlockState fillBlock;
    private final boolean checkStability;

    public WorldGenFissure(boolean lava) {
        this.fillBlock = lava ? ChunkGenTFC.LAVA : ChunkGenTFC.HOT_WATER;
        this.checkStability = lava;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int y;
        BlockPos start = new ChunkPos(chunkX, chunkZ).func_180331_a(random.nextInt(14) + 9, 0, random.nextInt(14) + 9);
        Biome biome = world.func_180494_b(start);
        if (biome == BiomesTFC.BEACH || biome == BiomesTFC.OCEAN || biome == BiomesTFC.GRAVEL_BEACH || biome == BiomesTFC.LAKE || biome == BiomesTFC.RIVER || biome == BiomesTFC.DEEP_OCEAN) {
            return;
        }
        start = world.func_175672_r(start).func_177979_c(3);
        boolean stable = ChunkDataTFC.isStable(world, start);
        if (this.checkStability && stable) {
            return;
        }
        IBlockState rock = BlockRockVariant.get(ChunkDataTFC.getRock3(world, start), Rock.Type.RAW).func_176223_P();
        int depth = 2 + random.nextInt(3);
        int radius = 1 + random.nextInt(2);
        List<BlockPos> clearing = this.getCircle(start, radius + 2);
        for (y = 1; y < 4; ++y) {
            for (BlockPos pos : clearing) {
                IBlockState block = world.func_180495_p(pos.func_177981_b(y));
                if (!BlocksTFC.isWater(block) || BlocksTFC.isGround(block)) continue;
                return;
            }
        }
        for (y = 1; y < 4; ++y) {
            for (BlockPos clear : clearing) {
                world.func_175698_g(clear.func_177981_b(y));
            }
        }
        Set<BlockPos> blocks = this.getCollapseSet(random, start, radius, depth);
        for (BlockPos filling : blocks) {
            this.smartFill(world, filling, blocks, rock, this.fillBlock);
        }
    }

    private List<BlockPos> getCircle(BlockPos center, int radius) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        double rSq = Math.pow(radius, 2.0);
        for (int x = -radius + center.func_177958_n(); x <= radius + center.func_177958_n(); ++x) {
            for (int z = -radius + center.func_177952_p(); z <= radius + center.func_177952_p(); ++z) {
                if (!(Math.pow(x - center.func_177958_n(), 2.0) + Math.pow(z - center.func_177952_p(), 2.0) <= rSq)) continue;
                list.add(new BlockPos(x, center.func_177956_o(), z));
            }
        }
        return list;
    }

    private Set<BlockPos> getCollapseSet(Random random, BlockPos center, int radius, int depth) {
        int maxOffset = 2 + random.nextInt(radius);
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int y = 0; y < depth; ++y) {
            BlockPos centerHeight = center.func_177979_c(y);
            double rSq = Math.pow(radius, 2.0);
            for (int x = -radius + centerHeight.func_177958_n(); x <= radius + centerHeight.func_177958_n(); ++x) {
                for (int z = -radius + centerHeight.func_177952_p(); z <= radius + centerHeight.func_177952_p(); ++z) {
                    if (!(Math.pow(x - centerHeight.func_177958_n(), 2.0) + Math.pow(z - centerHeight.func_177952_p(), 2.0) <= rSq)) continue;
                    BlockPos b = new BlockPos(x, centerHeight.func_177956_o(), z);
                    if (!(random.nextFloat() < 0.65f)) continue;
                    blocks.add(b);
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        if (facing == EnumFacing.UP) continue;
                        for (int off = 0; off < maxOffset && random.nextFloat() < 0.35f; ++off) {
                            blocks.add(b.func_177972_a(facing));
                        }
                    }
                }
            }
        }
        int tunnelDepth = depth + 20 + random.nextInt(60);
        int tunnelY = center.func_177979_c(tunnelDepth).func_177956_o();
        if (tunnelY < 20) {
            tunnelY = 20;
        }
        BlockPos tunnelPos = center.func_177979_c(depth);
        blocks.add(tunnelPos);
        radius = 8;
        while (tunnelPos.func_177956_o() > tunnelY) {
            int value = random.nextInt(8);
            tunnelPos = value < 1 ? tunnelPos.func_177972_a(EnumFacing.NORTH) : (value < 2 ? tunnelPos.func_177972_a(EnumFacing.SOUTH) : (value < 3 ? tunnelPos.func_177972_a(EnumFacing.EAST) : (value < 4 ? tunnelPos.func_177972_a(EnumFacing.WEST) : tunnelPos.func_177977_b())));
            if (tunnelPos.func_177958_n() > center.func_177958_n() + radius) {
                tunnelPos = tunnelPos.func_177982_a(-1, 0, 0);
            }
            if (tunnelPos.func_177958_n() < center.func_177958_n() - radius) {
                tunnelPos = tunnelPos.func_177982_a(1, 0, 0);
            }
            if (tunnelPos.func_177952_p() > center.func_177952_p() + radius) {
                tunnelPos = tunnelPos.func_177982_a(0, 0, -1);
            }
            if (tunnelPos.func_177952_p() < center.func_177952_p() - radius) {
                tunnelPos = tunnelPos.func_177982_a(0, 0, 1);
            }
            blocks.add(tunnelPos);
            for (EnumFacing horiz : EnumFacing.field_176754_o) {
                blocks.add(tunnelPos.func_177972_a(horiz));
            }
        }
        return blocks;
    }

    private void smartFill(World world, BlockPos pos, Set<BlockPos> fillBlockPos, IBlockState rock, IBlockState fillBlock) {
        world.func_175656_a(pos, fillBlock);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing == EnumFacing.UP || world.func_180495_p(pos.func_177972_a(facing)) == fillBlock) continue;
            BlockPos rockPos = pos.func_177972_a(facing);
            int filledBlocks = 0;
            for (EnumFacing facing2 : EnumFacing.field_82609_l) {
                BlockPos facingPos = rockPos.func_177972_a(facing2);
                if (!fillBlockPos.contains(facingPos)) continue;
                ++filledBlocks;
            }
            if (filledBlocks < 3) {
                world.func_175656_a(rockPos, rock);
                continue;
            }
            world.func_175656_a(rockPos, fillBlock);
        }
    }
}

